<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Mambkongregasyon;
use Validator;
use Yajra\DataTables\Facades\DataTables;
use Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\ResponseController;

class MambkongregasyonController extends Controller
{
    
    public $Now;
    public $Response;
    public function __construct(){
        parent::__construct();
        $this->Now=date('Y-m-d H:i:s');
        $this->Response=new ResponseController();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return View('Mambkongregasyon_list');
    }
    
    /**
     * 
     * @return type 
     */
    public function All()
    {
        $Mambkongregasyon=Mambkongregasyon::query();
        $Mambkongregasyon=$Mambkongregasyon->with('role');
        return Datatables::of($Mambkongregasyon)->addColumn('Select', function($Mambkongregasyon) { return '<input class="flat Mambkongregasyon_record" name="Mambkongregasyon_record"  type="checkbox" value="'.$Mambkongregasyon->id.'" />';})
                ->addColumn('actions', function ($Mambkongregasyon) {
                $column='<a href="'.route('Mambkongregasyonview',$Mambkongregasyon->id).'"  class="btn btn-xs btn-primary"><i class="glyphicon glyphicon-edit"></i> View</a>';
                $column.='<a href="'.route('Mambkongregasyonedit',$Mambkongregasyon->id).'"  class="btn btn-xs btn-primary"><i class="glyphicon glyphicon-edit"></i> Edit</a>';
                $column.='<a href="javascript:void(0)" data-url="'.route('Mambkongregasyondelete',$Mambkongregasyon->id).'" class="delete btn btn-xs btn-primary"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
                return $column;})->make(true);
    }

    private function validateCreateOrUpdate(Request $request){
        return Validator::make($request->all(), array (
  'firstname' => 
  array (
    0 => 'string',
  ),
  'lastname' => 
  array (
  ),
  'address1' => 
  array (
  ),
  'address2' => 
  array (
  ),
  'city' => 
  array (
  ),
  'state' => 
  array (
  ),
  'zip' => 
  array (
    0 => 'string',
  ),
  'role' => 
  array (
    0 => 'integer',
  ),
));
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function CreateOrUpdate(Request $request)
    {
        try {
            $validationResult = $this->validateCreateOrUpdate($request);
            if($validationResult->fails()){
                return $this->Response->prepareResult(400,null,$validationResult->errors(),null,'ajax',null,'Mambkongregasyon Could not be  Saved');
            }
            if($request['id'] !=''):
                $Mambkongregasyon = Mambkongregasyon::where('id',$request['id'])->first();    
                $Mambkongregasyon->firstname=strip_tags($request["firstname"]);$Mambkongregasyon->lastname=strip_tags($request["lastname"]);$Mambkongregasyon->address1=strip_tags($request["address1"]);$Mambkongregasyon->address2=strip_tags($request["address2"]);$Mambkongregasyon->city=strip_tags($request["city"]);$Mambkongregasyon->state=strip_tags($request["state"]);$Mambkongregasyon->zip=strip_tags($request["zip"]);$Mambkongregasyon->role=$request["role"];
                $Mambkongregasyon->save();
                return $this->Response->prepareResult(200,$Mambkongregasyon,[],'Mambkongregasyon Saved successfully ','ajax');
            else:
                $Mambkongregasyon=new Mambkongregasyon();    
                $Mambkongregasyon->firstname=strip_tags($request["firstname"]);$Mambkongregasyon->lastname=strip_tags($request["lastname"]);$Mambkongregasyon->address1=strip_tags($request["address1"]);$Mambkongregasyon->address2=strip_tags($request["address2"]);$Mambkongregasyon->city=strip_tags($request["city"]);$Mambkongregasyon->state=strip_tags($request["state"]);$Mambkongregasyon->zip=strip_tags($request["zip"]);$Mambkongregasyon->role=$request["role"];
                $Mambkongregasyon->save();
                return $this->Response->prepareResult(200,$Mambkongregasyon,[],'Mambkongregasyon Created successfully ','ajax');
            endif;
        } catch (Exception $exc) {
                return $this->Response->prepareResult(400,null,[],null,'ajax','Mambkongregasyon Could not be  Saved');
        }

        
        
    }

    /**
     * Show the viw the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function view($ID)
    {
        try {
                $data=Mambkongregasyon::where('id',$ID)->firstOrFail();        
                return $this->Response->prepareResult(200,$data,[],null,'view','Mambkongregasyon_view');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function edit($ID)
    {
        try {
                $data=Mambkongregasyon::where('id',$ID)->firstOrFail();                
                return $this->Response->prepareResult(200,$data,[],null,'view','Mambkongregasyon_edit');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }
    
    /**
     * Show the form for add the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function add()
    {
        try {
                $data=new \stdClass();                
                return $this->Response->prepareResult(200,$data,[],null,'view','Mambkongregasyon_add');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function Delete($ID)
    {
        try {
                Mambkongregasyon::where('id',$ID)->delete();
                return  $this->Response->prepareResult(200,[],'Mambkongregasyon Item deleted Successfully','ajax');
            } catch (\Exception $exc) {
        }        return $this->Response->prepareResult(400,[],null,'ajax','Mambkongregasyon Item Could be not deleted');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function DeleteMultiple(Request $request)
    {
        try {
                Mambkongregasyon::whereIn('id',$request->selected_rows)->delete();
                return  $this->Response->prepareResult(200,[],'Mambkongregasyon Item/s deleted Successfully','ajax');
            } catch (\Exception $exc) {
        }        return $this->Response->prepareResult(400,[],null,'ajax','Mambkongregasyon Item/s Could be not deleted');
    }
    
    /**
     * Upload Attachment Or Image
     */
    protected function Upload(Request $request,$FieldName)
    {
        $path='';
        $Image = $request->file($FieldName);
        if($Image):
            $Extension = $Image->getClientOriginalExtension();
            $path = $Image->getFilename() . '.' . $Extension;
            Storage::disk('files_folder')->put($path, File::get($request->file($FieldName)));
        endif;
        return $path;
    }
}
