<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Usersubroles;
use Validator;
use Yajra\DataTables\Facades\DataTables;
use Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\ResponseController;

class UsersubrolesController extends Controller
{
    
    public $Now;
    public $Response;
    public function __construct(){
        parent::__construct();
        $this->Now=date('Y-m-d H:i:s');
        $this->Response=new ResponseController();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return View('Usersubroles_list');
    }
    
    /**
     * 
     * @return type 
     */
    public function All()
    {
        $Usersubroles=Usersubroles::query();
        
        return Datatables::of($Usersubroles)->addColumn('Select', function($Usersubroles) { return '<input class="flat Usersubroles_record" name="Usersubroles_record"  type="checkbox" value="'.$Usersubroles->id.'" />';})
                ->addColumn('actions', function ($Usersubroles) {
                $column='<a href="'.route('Usersubrolesview',$Usersubroles->id).'"  class="btn btn-xs btn-primary"><i class="glyphicon glyphicon-edit"></i> View</a>';
                $column.='<a href="'.route('Usersubrolesedit',$Usersubroles->id).'"  class="btn btn-xs btn-primary"><i class="glyphicon glyphicon-edit"></i> Edit</a>';
                $column.='<a href="javascript:void(0)" data-url="'.route('Usersubrolesdelete',$Usersubroles->id).'" class="delete btn btn-xs btn-primary"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
                return $column;})->make(true);
    }

    private function validateCreateOrUpdate(Request $request){
        return Validator::make($request->all(), array (
  'subrole' => 
  array (
    0 => 'string',
  ),
  'subrole_priority' => 
  array (
    0 => 'integer',
  ),
));
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function CreateOrUpdate(Request $request)
    {
        try {
            $validationResult = $this->validateCreateOrUpdate($request);
            if($validationResult->fails()){
                return $this->Response->prepareResult(400,null,$validationResult->errors(),null,'ajax',null,'Usersubroles Could not be  Saved');
            }
            if($request['id'] !=''):
                $Usersubroles = Usersubroles::where('id',$request['id'])->first();    
                $Usersubroles->subrole=strip_tags($request["subrole"]);$Usersubroles->subrole_priority=strip_tags($request["subrole_priority"]);
                $Usersubroles->save();
                return $this->Response->prepareResult(200,$Usersubroles,[],'Usersubroles Saved successfully ','ajax');
            else:
                $Usersubroles=new Usersubroles();    
                $Usersubroles->subrole=strip_tags($request["subrole"]);$Usersubroles->subrole_priority=strip_tags($request["subrole_priority"]);
                $Usersubroles->save();
                return $this->Response->prepareResult(200,$Usersubroles,[],'Usersubroles Created successfully ','ajax');
            endif;
        } catch (Exception $exc) {
                return $this->Response->prepareResult(400,null,[],null,'ajax','Usersubroles Could not be  Saved');
        }

        
        
    }

    /**
     * Show the viw the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function view($ID)
    {
        try {
                $data=Usersubroles::where('id',$ID)->firstOrFail();        
                return $this->Response->prepareResult(200,$data,[],null,'view','Usersubroles_view');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function edit($ID)
    {
        try {
                $data=Usersubroles::where('id',$ID)->firstOrFail();                
                return $this->Response->prepareResult(200,$data,[],null,'view','Usersubroles_edit');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }
    
    /**
     * Show the form for add the specified resource.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function add()
    {
        try {
                $data=new \stdClass();                
                return $this->Response->prepareResult(200,$data,[],null,'view','Usersubroles_add');
            } catch (\Exception $exc) {
                 return $this->Response->prepareResult(400,[],null,'view','Could not get This item');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function Delete($ID)
    {
        try {
                Usersubroles::where('id',$ID)->delete();
                return  $this->Response->prepareResult(200,[],'Usersubroles Item deleted Successfully','ajax');
            } catch (\Exception $exc) {
        }        return $this->Response->prepareResult(400,[],null,'ajax','Usersubroles Item Could be not deleted');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $ID
     * @return \Illuminate\Http\Response
     */
    public function DeleteMultiple(Request $request)
    {
        try {
                Usersubroles::whereIn('id',$request->selected_rows)->delete();
                return  $this->Response->prepareResult(200,[],'Usersubroles Item/s deleted Successfully','ajax');
            } catch (\Exception $exc) {
        }        return $this->Response->prepareResult(400,[],null,'ajax','Usersubroles Item/s Could be not deleted');
    }
    
    /**
     * Upload Attachment Or Image
     */
    protected function Upload(Request $request,$FieldName)
    {
        $path='';
        $Image = $request->file($FieldName);
        if($Image):
            $Extension = $Image->getClientOriginalExtension();
            $path = $Image->getFilename() . '.' . $Extension;
            Storage::disk('files_folder')->put($path, File::get($request->file($FieldName)));
        endif;
        return $path;
    }
}
